/************************************************************************
*
* Copyright:
*	Freescale Semiconductor, INC. All Rights Reserved.  
*  You are hereby granted a copyright license to use, modify, and
*  distribute the SOFTWARE so long as this entire notice is
*  retained without alteration in any modified and/or redistributed
*  versions, and that such modified versions are clearly identified
*  as such. No licenses are granted by implication, estoppel or
*  otherwise under any patents or trademarks of Freescale Semiconductor, 
*  Inc. This software is provided on an "AS IS" basis and without warranty.
*
*  To the maximum extent permitted by applicable law, FREESCALE 
*  DISCLAIMS ALL WARRANTIES WHETHER EXPRESS OR IMPLIED, INCLUDING 
*  IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
*  PURPOSE AND ANY WARRANTY AGAINST INFRINGEMENT WITH REGARD TO THE 
*  SOFTWARE (INCLUDING ANY MODIFIED VERSIONS THEREOF) AND ANY 
*  ACCOMPANYING WRITTEN MATERIALS.
* 
*  To the maximum extent permitted by applicable law, IN NO EVENT
*  SHALL FREESCALE BE LIABLE FOR ANY DAMAGES WHATSOEVER (INCLUDING 
*  WITHOUT LIMITATION, DAMAGES FOR LOSS OF BUSINESS PROFITS, BUSINESS 
*  INTERRUPTION, LOSS OF BUSINESS INFORMATION, OR OTHER PECUNIARY
*  LOSS) ARISING OF THE USE OR INABILITY TO USE THE SOFTWARE.   
* 
*  Freescale assumes no responsibility for the maintenance and support
*  of this software
*************************************************************************
*
*  FILE NAME: iir16.h
*
*  PURPOSE: IIR16 functions and data structures declarations
*
*  AUTHOR: Andrey Butok
*	Modified by Igor Drozdinsky
*
***********************************************************************/
#ifndef _IIR_16_H_
#define _IIR_16_H_

#include "iir.h"

//16-bit Fractional IIR Filter
typedef struct tIir16Struct
	{
	Frac16* pIirCoef;                    //Coefficients for IIR-> {a0,a1,b1,a2,b2...}
	unsigned int    iIirCoefCount;	 //Number of Coefficients=2n+1 (n=1,2,3...)
	Frac16* pIirHistory;                 // Buffer for Save hisory between function calls -> {X1,Y1,X2,Y2,X3...}
	unsigned int    iIirHistoryCount;    // Number of values in History Buffer
	};


/************************************************************************
*     Function Prototypes
************************************************************************/

 // Computes a Infinite Impulse Response (IIR) filter for a array of 16-bit fractional data values.
 void IIR16_EMAC( struct tIir16Struct *pIIR, Frac16* pX, Frac16* pY, unsigned int n);
 void IIR16_MAC( struct tIir16Struct *pIIR, Frac16* pX, Frac16* pY, unsigned int n);

 //Performs the initialization for IIR16 function
struct tIir16Struct* IIR16Create( Frac16* pCoef, uint16 u16Num);

 //Deallocates the data structure initially allocated by IIR16Create
void IIR16Destroy( struct tIir16Struct* pIIR);


#ifdef __EMAC
	#define IIR16(w,x,y,z)	IIR16_EMAC(w,x,y,z)
#else
	#define IIR16(w,x,y,z)	IIR16_MAC(w,x,y,z)
#endif

#endif //_IIR_16_H_



